Public Class Car
    Implements IDisposable

    ' Donnes d'tat internes.
    Private currSpeed As Integer
    Private maxSpeed As Integer
    Private petName As String

    ' Utiliser pour savoir si nous sommes actuellement librs.
    Private disposed As Boolean

    ' Constructeur.
    Public Sub New()
        maxSpeed = 100
    End Sub
    Public Sub New(ByVal name As String, ByVal max As Integer, ByVal curr As Integer)
        currSpeed = curr
        maxSpeed = max
        petName = name
    End Sub

    ' Cette mthode sera appele par les mthodes
    ' de destruction implicites et explicites.
    Private Sub CleanUpInternalResources()
        If (disposed = False) Then
            disposed = True
            Console.WriteLine("Nettoyage des ressources internes...")
        End If
    End Sub

    ' Cette mthode sera appele par le runtime quand un GC est ncssaire.
    Protected Overrides Sub Finalize()
        Console.WriteLine("Dans la mthode Finalize() pour {0}!", petName)
        CleanUpInternalResources()
    End Sub

    ' Implmentation de IDisposable.
    ' Appel par les clients quand ils ont termin.
    Public Sub Dispose() Implements IDisposable.Dispose
        Console.WriteLine("Dans la mthode Dispose() pour {0}!", petName)
        ' Il est inutile de finaliser si l'utilisateur
        ' appelle Dispose() manuellement.
        CleanUpInternalResources()
        System.GC.SuppressFinalize(Me)
    End Sub
End Class
